/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.hibiscus.naturespirit.datagen.NSDataGen;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.hibiscus.naturespirit.registration.NSColoredBlocks;
import net.hibiscus.naturespirit.registration.NSMiscBlocks;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.hibiscus.naturespirit.registration.NSWoods;
import net.hibiscus.naturespirit.registration.sets.FlowerSet;
import net.hibiscus.naturespirit.registration.sets.StoneSet;
import net.hibiscus.naturespirit.registration.sets.WoodSet;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

class NSLangGenerator
extends FabricLanguageProvider {
    protected NSLangGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    private void generateBlockTranslations(class_2248 block, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        String temp = NSLangGenerator.capitalizeString(class_7923.field_41175.method_10221((Object)block).method_12832().replace("_", " "));
        translationBuilder.add(block, temp);
    }

    private void generateItemTranslations(class_1792 item, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        String temp = NSLangGenerator.capitalizeString(class_7923.field_41178.method_10221((Object)item).method_12832().replace("_", " "));
        translationBuilder.add(item, temp);
    }

    private void generateWoodTranslations(HashMap<String, WoodSet> woods, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (WoodSet woodSet : woods.values()) {
            for (class_2248 block : woodSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
            this.generateBlockTranslations(woodSet.getSign(), translationBuilder);
            this.generateBlockTranslations(woodSet.getHangingSign(), translationBuilder);
            translationBuilder.add(woodSet.getBoatItem(), NSLangGenerator.capitalizeString(woodSet.getName().replace("_", " ")) + " Boat");
            translationBuilder.add(woodSet.getChestBoatItem(), NSLangGenerator.capitalizeString(woodSet.getName().replace("_", " ")) + " Boat with Chest");
            this.generateArchExTranslations(woodSet.getName(), translationBuilder);
        }
    }

    private void generateStoneTranslations(HashMap<String, StoneSet> stones, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (StoneSet stoneSet : stones.values()) {
            for (class_2248 block : stoneSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
        }
    }

    private void generateFlowerTranslations(HashMap<String, FlowerSet> flowers, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (FlowerSet flowerSet : flowers.values()) {
            for (class_2248 block : flowerSet.getRegisteredBlocksList()) {
                this.generateBlockTranslations(block, translationBuilder);
            }
        }
    }

    private void generateBiomeTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (String name : NSBiomes.BiomesHashMap.keySet()) {
            class_5321<class_1959> biome = NSBiomes.BiomesHashMap.get(name);
            translationBuilder.add(biome.toString().replace("ResourceKey[minecraft:worldgen/biome / natures_spirit:", "biome.natures_spirit.").replace("]", ""), NSLangGenerator.capitalizeString(name.replace("_", " ")));
        }
    }

    private void generateArchExTranslations(String group, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("architecture_extensions.grouped_block.natures_spirit." + group, NSLangGenerator.capitalizeString(group.replace("_", " ")));
    }

    private void generateColoredTranslations(String group, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("block.natures_spirit." + group, NSLangGenerator.capitalizeString(group.replace("_", " ")));
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.generateBiomeTranslations(translationBuilder);
        this.generateWoodTranslations(NSRegistryHelper.WoodHashMap, translationBuilder);
        this.generateStoneTranslations(NSRegistryHelper.StoneHashMap, translationBuilder);
        this.generateFlowerTranslations(NSRegistryHelper.FlowerHashMap, translationBuilder);
        translationBuilder.add("itemGroup.natures_spirit.item_group", "Nature's Spirit");
        translationBuilder.add("stat.minecraft.eat_pizza_slice", "Pizza Slices Eaten");
        translationBuilder.add("advancements.adventure.kaolin_kill.description", "Kill a Zombie with a Kaolin block");
        translationBuilder.add("advancements.adventure.kaolin_kill.title", "You're Kaolin This!");
        translationBuilder.add("advancements.adventure.shoot_coconut.description", "Hit a Coconut with a projectile");
        translationBuilder.add("advancements.adventure.shoot_coconut.title", "Tropical Blast!");
        translationBuilder.add("advancements.adventure.collect_all_flowers.description", "Collect all flowers.");
        translationBuilder.add("advancements.adventure.collect_all_flowers.title", "Flower Power");
        translationBuilder.add("advancements.adventure.sandy_forage.description", "Follow the Roots of a Turnip to a Turnip block");
        translationBuilder.add("advancements.adventure.sandy_forage.title", "Sandy Forage");
        this.generateItemTranslations(NSMiscBlocks.CHALK_POWDER, translationBuilder);
        this.generateItemTranslations(NSMiscBlocks.OLIVES, translationBuilder);
        this.generateItemTranslations(NSMiscBlocks.DESERT_TURNIP, translationBuilder);
        this.generateItemTranslations(NSMiscBlocks.CALCITE_SHARD, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SMALL_CALCITE_BUD, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LARGE_CALCITE_BUD, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CALCITE_CLUSTER, translationBuilder);
        this.generateBlockTranslations(NSWoods.OLIVE_BRANCH, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_SCORCHED_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PURPLE_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.RED_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.GREEN_BEARBERRIES, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.RED_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PURPLE_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.GREEN_BITTER_SPROUTS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SCORCHED_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_BEACH_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.BEACH_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_SEDGE_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SEDGE_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_FRIGID_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FRIGID_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LARGE_FLAXEN_FERN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FLAXEN_FERN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_OAT_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.OAT_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LARGE_LUSH_FERN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LUSH_FERN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.TALL_MELIC_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.MELIC_GRASS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SHIITAKE_MUSHROOM, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.GRAY_POLYPORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.GRAY_POLYPORE_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FRAMED_PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.BLOOMING_PAPER_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FRAMED_PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.BLOOMING_PAPER_DOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.BLOOMING_PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FRAMED_PAPER_TRAPDOOR, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_SIGN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_HANGING_SIGN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FRAMED_PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.BLOOMING_PAPER_PANEL, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.PAPER_LANTERN, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CATTAIL, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.DESERT_TURNIP_ROOT_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.DESERT_TURNIP_BLOCK, translationBuilder);
        translationBuilder.add(NSMiscBlocks.HELVOLA_PAD_ITEM, "Helvola Pad");
        this.generateItemTranslations(NSMiscBlocks.HELVOLA_FLOWER_ITEM, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.AZOLLA, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LOTUS_FLOWER, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.LOTUS_STEM, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.RED_MOSS_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.RED_MOSS_CARPET, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.ALLUAUDIA, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.ALLUAUDIA_BUNDLE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.STRIPPED_ALLUAUDIA, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_COAL_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_COPPER_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_DIAMOND_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_GOLD_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_EMERALD_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_IRON_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_LAPIS_ORE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHERT_REDSTONE_ORE, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN_BRICKS, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN_SLAB, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN_BRICK_SLAB, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSColoredBlocks.KAOLIN_BRICK_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_SPROUT, translationBuilder);
        this.generateItemTranslations(NSWoods.COCONUT_SHELL, translationBuilder);
        this.generateItemTranslations(NSWoods.COCONUT_HALF, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_THATCH, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSWoods.COCONUT_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(NSWoods.EVERGREEN_THATCH, translationBuilder);
        this.generateBlockTranslations(NSWoods.EVERGREEN_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(NSWoods.EVERGREEN_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSWoods.EVERGREEN_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(NSWoods.XERIC_THATCH, translationBuilder);
        this.generateBlockTranslations(NSWoods.XERIC_THATCH_SLAB, translationBuilder);
        this.generateBlockTranslations(NSWoods.XERIC_THATCH_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSWoods.XERIC_THATCH_CARPET, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.ORNATE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.DROWSY_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.AUREATE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SAGE_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.FOAMY_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.IMPERIAL_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.REGAL_SUCCULENT, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PINK_SAND, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PINK_SANDSTONE_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.PINK_SANDSTONE_WALL, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SMOOTH_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHISELED_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CUT_PINK_SANDSTONE, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CUT_PINK_SANDSTONE_SLAB, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.SANDY_SOIL, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHEESE_BLOCK, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.CHEESE_CAULDRON, translationBuilder);
        this.generateBlockTranslations(NSMiscBlocks.MILK_CAULDRON, translationBuilder);
        translationBuilder.add(NSMiscBlocks.CHEESE_BUCKET, "Cheese Bucket");
        translationBuilder.add(NSMiscBlocks.CHEESE_ARROW, "Cheese Arrow");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_chicken", "With Cooked Chicken");
        translationBuilder.add("block.natures_spirit.pizza.natures_spirit.olives", "With Olives");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.brown_mushroom", "With Mushrooms");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.beetroot", "With Beetroots");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.carrot", "With Carrots");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_cod", "With Cooked Cod");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_porkchop", "With Cooked Porkchop");
        translationBuilder.add("block.natures_spirit.pizza.minecraft.cooked_rabbit", "With Cooked Rabbit");
        translationBuilder.add(NSMiscBlocks.HALF_PIZZA, "Half of a Pizza");
        translationBuilder.add(NSMiscBlocks.THREE_QUARTERS_PIZZA, "Three Quarters of a Pizza");
        translationBuilder.add(NSMiscBlocks.QUARTER_PIZZA, "Quarter of a Pizza");
        translationBuilder.add(NSMiscBlocks.WHOLE_PIZZA, "Pizza");
        translationBuilder.add("pack.natures_spirit.bushy_leaves_compatibility", "Bushy Leaves Compat");
        translationBuilder.add("pack.natures_spirit.plank_consistency", "Plank Consistency");
        translationBuilder.add("pack.natures_spirit.emissive_ores_compatibility", "Emissive Ores Compat");
        translationBuilder.add("pack.natures_spirit.modified_swamp", "Modified Swamp");
        translationBuilder.add("pack.natures_spirit.modified_desert", "Modified Desert");
        translationBuilder.add("pack.natures_spirit.modified_birch_forest", "Modified Birch Forest");
        translationBuilder.add("pack.natures_spirit.modified_badlands", "Modified Badlands");
        translationBuilder.add("pack.natures_spirit.modified_savannas", "Modified Savannas");
        translationBuilder.add("pack.natures_spirit.modified_dark_forest", "Modified Dark Forests");
        translationBuilder.add("pack.natures_spirit.modified_mountain_biomes", "Modified Mountain Biomes");
        translationBuilder.add("pack.natures_spirit.modified_vanilla_trees", "Modified Vanilla Trees");
        translationBuilder.add("pack.natures_spirit.modified_windswept_hills", "Modified Windswept Hills");
        translationBuilder.add("pack.natures_spirit.modified_jungle", "Modified Jungles");
        translationBuilder.add("pack.natures_spirit.modified_flower_forest", "Modified Flower Forests");
        translationBuilder.add("painting.natures_spirit.redwood.title", "Woody Spires");
        translationBuilder.add("painting.natures_spirit.redwood.author", "Aeramisu");
        translationBuilder.add("painting.natures_spirit.lavender.title", "Happy Days");
        translationBuilder.add("painting.natures_spirit.lavender.author", "Aeramisu");
        translationBuilder.add("painting.natures_spirit.aspen.title", "Aureate");
        translationBuilder.add("painting.natures_spirit.aspen.author", "Aeramisu");
        translationBuilder.add("painting.natures_spirit.sandy_trees.title", "Lost");
        translationBuilder.add("painting.natures_spirit.sandy_trees.author", "Aeramisu");
        this.generateArchExTranslations("kaolin", translationBuilder);
        this.generateArchExTranslations("kaolin_bricks", translationBuilder);
        for (String color : List.of(NSDataGen.DYE_COLORS)) {
            this.generateArchExTranslations(color + "_kaolin", translationBuilder);
            this.generateArchExTranslations(color + "_kaolin_bricks", translationBuilder);
            this.generateArchExTranslations(color + "_chalk", translationBuilder);
            this.generateColoredTranslations(color + "_paper_lantern", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_bricks", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_slab", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_brick_slab", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_stairs", translationBuilder);
            this.generateColoredTranslations(color + "_kaolin_brick_stairs", translationBuilder);
            this.generateColoredTranslations(color + "_chalk", translationBuilder);
            this.generateColoredTranslations(color + "_chalk_slab", translationBuilder);
            this.generateColoredTranslations(color + "_chalk_stairs", translationBuilder);
        }
        this.generateColoredTranslations("bleached_chalk", translationBuilder);
        this.generateColoredTranslations("bleached_chalk_slab", translationBuilder);
        this.generateColoredTranslations("bleached_chalk_stairs", translationBuilder);
        this.generateArchExTranslations("pink_sandstone", translationBuilder);
        this.generateArchExTranslations("smooth_pink_sandstone", translationBuilder);
        this.generateArchExTranslations("travertine", translationBuilder);
        this.generateArchExTranslations("travertine_bricks", translationBuilder);
        this.generateArchExTranslations("travertine_tiles", translationBuilder);
        this.generateArchExTranslations("cobbled_travertine", translationBuilder);
        this.generateArchExTranslations("mossy_cobbled_travertine", translationBuilder);
        this.generateArchExTranslations("mossy_travertine_bricks", translationBuilder);
    }
}

